unit ZPL_Delphi;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, PrinterLib,
  Controls, Forms,  Dialogs, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

function UnicodeToAnsi(Str: String): AnsiString;
var
  Len: integer;
begin
  Len := Length(Str) * 2 + 1; // one for #0
  SetLength(Result, Len);
  Len := WideCharToMultiByte(CP_ACP, 0, PWideChar(Str), -1, PAnsiChar(Result),
    Len, nil, nil);
  SetLength(Result, Len);
end;

function AnsiToUnicode(Str: AnsiString): String;
var
  Len: integer;
begin
  Len := Length(Str) + 1;
  SetLength(Result, Len);
  Len := MultiByteToWideChar(CP_ACP, 0, PAnsiChar(Str), -1, PWideChar(Result),
    Len);
  SetLength(Result, Len); // end is #0
end;
{$R *.dfm}
function  RFIDTEXT_HL():Integer;
var
     iResult: integer;
begin
  iResult := DemoPrinterCreator('HT300');
  if iResult = 0 then
  begin
    iResult := DemoPortOpen('USB');
    if iResult = 0 then
    begin
      //ʼ
      iResult := DemoStartFormat();

      iResult := DemoRfidReturnHostDatalog();
      //
      iResult := DemoEndFormat();

      //ɾӡ
      iResult := DemoPortClose();

      //
      iResult := DemoPrinterDestroy();

    end
    else
    begin
        ShowMessage('Usb Device not found');
    end;
  end
  else
  begin
      ShowMessage('Printer not found');
  end;
end;

function  RFIDTEXT_HR():Integer;
var
     iResult: integer;
     pStartStr : pchar;
     pEndStr : pchar;
     pStartPosition : pchar;
     pEndPosition : pchar;
     model : Char;
begin
  iResult := DemoPrinterCreator('HT300');
   pStartStr := 'start';
   pEndStr := 'end';
   pStartPosition := 'B20';
   pEndPosition := 'F42';
   model := 'M';
  if iResult = 0 then
  begin
    iResult := DemoPortOpen('USB');
    if iResult = 0 then
    begin
      //ʼ
      iResult := DemoStartFormat();

      iResult := DemoRfidCorrectXpdnrPosition(pStartStr, pEndStr, pStartPosition, pEndPosition, model);
      //
      iResult := DemoEndFormat();

      //ɾӡ
      iResult := DemoPortClose();

      //
      iResult := DemoPrinterDestroy();

    end
    else
    begin
        ShowMessage('Usb Device not found');
    end;
  end
  else
  begin
      ShowMessage('Printer not found');
  end;
end;

function  RFIDTEXT_RB():Integer;
var
     iResult: integer;
     nTotalNum : Integer;
     pPartitionSize : array[0..6] of Integer;
     strText : ansistring;
begin
  iResult := DemoPrinterCreator('HT300');
  nTotalNum := 96;
  pPartitionSize[0]:= 8;
  pPartitionSize[1]:= 3;
  pPartitionSize[2]:= 3;
  pPartitionSize[3]:= 20;
  pPartitionSize[4]:= 24;
  pPartitionSize[5]:= 38;
  strText := '48,1,6,770289,10001025,1' ;
  if iResult = 0 then
  begin
    iResult := DemoPortOpen('USB');
    if iResult = 0 then
    begin
      //ʼ
      iResult := DemoStartFormat();
        iResult := Length(pPartitionSize);
      DemoRfidDefineDataStruct(nTotalNum, pPartitionSize, Length(pPartitionSize));

			DemoRfidWrite('E',0,1,'E',strText);

      //
      iResult := DemoEndFormat();

      //ɾӡ
      iResult := DemoPortClose();

      //
      iResult := DemoPrinterDestroy();

    end
    else
    begin
        ShowMessage('Usb Device not found');
    end;
  end
  else
  begin
      ShowMessage('Printer not found');
  end;
end;

function  RFIDTEXT_RR():Integer;
var
     iResult: integer;
     nRetryCount: integer;
begin
  iResult := DemoPrinterCreator('HT300');
  nRetryCount := 2;
  if iResult = 0 then
  begin
    iResult := DemoPortOpen('USB');
    if iResult = 0 then
    begin
      //ʼ
      iResult := DemoStartFormat();

      DemoRfidRetryCount(nRetryCount);

			DemoRfidWrite('H', 0, 1, 'E', '1234');
      //
      iResult := DemoEndFormat();

      //ɾӡ
      iResult := DemoPortClose();

      //
      iResult := DemoPrinterDestroy();

    end
    else
    begin
        ShowMessage('Usb Device not found');
    end;
  end
  else
  begin
      ShowMessage('Printer not found');
  end;
end;

function  RFIDTEXT_RS():Integer;
var
     iResult: integer;
     nTagNum: integer;
     nErrorAct: integer;
begin
  iResult := DemoPrinterCreator('HT300');
  nTagNum := 2;
  nErrorAct := 80;//P
  if iResult = 0 then
  begin
    iResult := DemoPortOpen('USB');
    if iResult = 0 then
    begin
      //ʼ
      iResult := DemoStartFormat();

      iResult := DemoRfidSetParameters(nTagNum, nErrorAct);
      //
      iResult := DemoEndFormat();

      //ɾӡ
      iResult := DemoPortClose();

      //
      iResult := DemoPrinterDestroy();

    end
    else
    begin
        ShowMessage('Usb Device not found');
    end;
  end
  else
  begin
      ShowMessage('Printer not found');
  end;
end;

function  RFIDTEXT_RW():Integer;
var
     iResult: integer;
     nReadPower: integer;
     nWritePower: integer;
     nAntennaType: integer;
begin
  iResult := DemoPrinterCreator('HT300');
  nReadPower := 72;//H
  nWritePower := 72;//H
  nAntennaType := 1;
  if iResult = 0 then
  begin
    iResult := DemoPortOpen('USB');
    if iResult = 0 then
    begin
      //ʼ
      //iResult := DemoStartFormat();

      iResult := DemoRfidSetPowerLevel(nReadPower,nWritePower,nAntennaType);
      //
      //iResult := DemoEndFormat();

      //ɾӡ
      iResult := DemoPortClose();

      //
      iResult := DemoPrinterDestroy();

    end
    else
    begin
        ShowMessage('Usb Device not found');
    end;
  end
  else
  begin
      ShowMessage('Printer not found');
  end;
end;

function  RFIDTEXT_RZ():Integer;
var
     iResult: integer;
     password :String;
     nMemoryBlock: integer;
     locktype : Char;
begin
  iResult := DemoPrinterCreator('HT300');
  password := '1234ABCD';
  nMemoryBlock := 69; //E
  locktype := 'L';

  if iResult = 0 then
  begin
    iResult := DemoPortOpen('USB');
    if iResult = 0 then
    begin
      //ʼ
      iResult := DemoStartFormat();

      DemoRfidWrite('H', 0, 1, 'E', '112233445566778899001122');

			DemoRfidSetLockTagAndPassword(password, nMemoryBlock, locktype);
      //
      iResult := DemoEndFormat();

      //ɾӡ
      iResult := DemoPortClose();

      //
      iResult := DemoPrinterDestroy();

    end
    else
    begin
        ShowMessage('Usb Device not found');
    end;
  end
  else
  begin
      ShowMessage('Printer not found');
  end;
end;

function  RFIDTEXT_RU():Integer;
var
     iResult: integer;
begin
  iResult := DemoPrinterCreator('HT300');
  if iResult = 0 then
  begin
    iResult := DemoPortOpen('USB');
    if iResult = 0 then
    begin
      //ʼ
      iResult := DemoStartFormat();

      DemoRfidReadChipSerialization();

      iResult := DemoScalableFontText(10,10,'0',78,50,50,'Serial Number: #H');//78 = E

			iResult := DemoRfidWrite('H', 0, 1, 'E', '12#H');
      //
      iResult := DemoEndFormat();

      //ɾӡ
      iResult := DemoPortClose();

      //
      iResult := DemoPrinterDestroy();

    end
    else
    begin
        ShowMessage('Usb Device not found');
    end;
  end
  else
  begin
      ShowMessage('Printer not found');
  end;
end;
procedure TForm1.Button1Click(Sender: TObject);
var
  iResult: integer;
  preadedNum: integer;
 // strrfid: array[0..8] of char;
  strrfid:PByte;
  str: array [0..19] of AnsiChar;
  pStr: PAnsiChar;
begin
  GetMem(strrfid, 10);
  iResult := DemoPrinterCreator('HT300');

  if iResult = 0 then
  begin
    iResult := DemoPortOpen('USB');
    if iResult = 0 then
    begin
      //ʼ
      iResult := DemoStartFormat();

      //ȡ汾Ϣ
       //SetLength(myByteArray, 20);
       FillChar(str, SizeOf(str), 0);
       pStr := @str[0];
       iResult := DemoGetPrinterFirmwareVersion(pStr);
      //ôӡŨ
      iResult := DemoSetPrintDarkness(20);

      //Ƿתӡ
      iResult := DemoSetPrintOrientation(180);

      //ӡͼƬ
      iResult := DemoPrintImage(100, 100, 'D:\\1.bmp');

      //ӡPdf417
      iResult := DemoPdf417(100, 250, 0, 2, 20, 2, 5, 5, 'N', '0010101101');

      //ӡBarCode39
      iResult := DemoBarCode39(100, 400, 0, 3, 50, 'Y', 'Y', 'Y', '66886868');

      //ӡCodeEan8
      iResult := DemoCodeEan8(100, 500, 0, 3, 60, 'Y', 'Y', '90381010');

      //ӡUPC-A
      iResult := DemoUpcaBarcode(100, 600, 0, 3, 50, 'Y', 'Y', 'N', '47631664454');

      //ӡUPCչ
      iResult := DemoUpcExtensions(100, 700, 0, 3, 50, 'Y', 'Y', '01234');

      //ӡά
      iResult := DemoQRCode(100, 800, 0, 1, 3, 'M', 'M','N', '1000000001');

      //ӡ
      iResult := DemoSetChangeFontEncoding(14);
      iResult := DemoText(100, 900, 16, 0, 40, 40, '');
      iResult := DemoText(300, 900, 16, 0, 40, 40, 'hello');
      iResult := DemoText(500, 900, 16, 0, 40, 40, 'ˤ');

      //ӡͼԲȦ
      iResult := DemoGraphicCircle(100, 1000, 150, 5);

      //ӡͼԲ
      iResult := DemoGraphicEllipse(300, 1000, 150, 100, 10);

      //ӡԽ
      iResult := DemoGraphicDiagonalLine(500, 1000, $52, 50, 50, 20);

      //ӡͼο
      iResult := DemoGraphicBox(100, 1200, 100, 100, 60, 3);

      //ӡ
      iResult := DemoGraphicSymbol(300, 1200, 0, 200, 200, 'A');

      //RFIDд
      //iResult := DemoRfidWrite('H', 2, 4, '1', '12345678');
      //iResult := DemoRfidRead('H', 2, 4, '1', 'a','z');

      //RFIDȡհ
      //iResult := DemoRfidReadEmpty();

      //Ƿе
      iResult := DemoSetPrintMode('C','Y');
      iResult := DemoCutter(0);
      iResult := DemoSetPrintQuantity(1,1,1,'Y');

      //
      iResult := DemoEndFormat();

      //iResult := DemoReadData(strrfid,10,preadedNum);

      //ɾӡ
      iResult := DemoPortClose();

      //
      iResult := DemoPrinterDestroy();
    end
    else
    begin
        ShowMessage('Usb Device not found');
    end;
  end
  else
  begin
      ShowMessage('Printer not found');
  end;

//  RFIDTEXT_HL();
//  RFIDTEXT_HR();
//  RFIDTEXT_RB();
//  RFIDTEXT_RR();
//  RFIDTEXT_RS();
//  RFIDTEXT_RW();
//  RFIDTEXT_RZ();
//  RFIDTEXT_RU();
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
//    showmessage('hello');
end;

end.
